<?php

//------------------------------------------------------------------------------
//    Widget Encart
//------------------------------------------------------------------------------

class Dh_Widget_Perso_Encart extends WP_Widget {

    public function __construct() {

        parent::__construct('dh_encart', 'Encart', array('description' => 'Widget Encart'));
        $this->alt_option_name = 'dh_encart_attachements';

        add_action('save_post', array(&$this, 'flush_widget_cache'));
        add_action('deleted_post', array(&$this, 'flush_widget_cache'));
        add_action('switch_theme', array(&$this, 'flush_widget_cache'));

        //add_action( 'wp_enqueue_scripts', array( $this, 'register_widget_styles' ) );
    }

    // ADD JS / CSS
    public function enqueue_upload_media() {
        if (!is_admin())
            return;

        wp_enqueue_media();
        wp_enqueue_script('upload_media_widget', get_template_directory_uri() . '/widgets/js/upload-media.js', array('jquery'));
    }

    // Front view
    function widget($args, $instance) {
        global $wpdb, $assetsUrl, $filetype_icons;

        $cache = wp_cache_get($this->alt_option_name, 'widget');

        if (!is_array($cache))
            $cache = array();

        if (!isset($args['widget_id']))
            $args['widget_id'] = null;

        if (isset($cache[$args['widget_id']])) {
            echo $cache[$args['widget_id']];
            return;
        }

        ob_start();
        extract($args, EXTR_SKIP);
        $data = json_decode($instance['data'], true);
        $title = apply_filters('widget_title', empty($instance['title']) ? __('', 'ex_attachments_widget') : $instance['title'], $instance, $this->id_base);

        echo $before_widget;
        echo "<div ";
        // Lien ancre
        $params = explode('=', $instance["ancre"]);
        if (!empty($params)) {
            $code_ancre = substr($params[1], 0, 8);
            echo "id='" . $code_ancre . "' ";
        }
        echo "class='wrapper-widget border-active light'>";
        ?>

        <?php
        // Gallerie Image
        if (!empty($data)) {
            ?>
            <div class="widget-galerie hoverimg" style="position:relative;">
                <?php foreach ($data as $key => $element):
				?>
                        <?php if (substr($element["link"], -4) == ".pdf") { ?>
                        <a href="<?php echo $element["link"]; ?>" target="_blank">
                        <?php echo $element["name"]; ?>
                        </a>
                <?php } else { ?>


                        <a class="fancybox-button" rel="gallery-<?php echo $args['widget_id']; ?>" href="<?php echo $element['link']; ?>" title="<?php echo $element['description']; ?>">
                            <img src="<?php echo $element['link']; ?>" alt="<?php echo $element['description']; ?>" title="<?php echo $element['description']; ?>"/>
                        </a>
                <?php } 
				
				if(!empty($element['description'])){
				?>
				<span class="legende_img_une"><?php echo $element['description']; ?></span>
				<?php
				}
				?>
            <?php endforeach; ?>
            </div>
        <?php } ?>

        <?php
        if ($title != "") {
            echo $before_title;
            echo $title;
            echo $after_title;
        }

        if ($instance["widget_description"] != "") {
            echo "<div class='text-widget'>" . nl2br($instance["widget_description"]) . "</div>";
        }

        if (!empty($instance["widget_link"]))
            echo "<a href='" . $instance["widget_link"] . "' target='_blank'>Lien</a>";
        ?>

        <?php
        echo "</div>"; // wrapper
        echo $after_widget;

        $cache[$args['widget_id']] = ob_get_flush();
        wp_cache_set($this->alt_option_name, $cache, 'widget');
    }

    function update($new_instance, $old_instance) {
        $instance = $old_instance;

        foreach ($new_instance as $key => $new) {
            $instance[$key] = $new;
        } $instance['title'] = strip_tags($new_instance['title']);


        $tempData = $new_instance['data'];
        $tempArray = array();

        foreach ($tempData as $value) {
            if (!empty($value)) {
                $tempArray[] = json_decode($value, true);
            }
        }

        $instance['data'] = json_encode($tempArray);
        $this->flush_widget_cache();

        $alloptions = wp_cache_get('alloptions', 'options');
        if (isset($alloptions[$this->alt_option_name]))
            delete_option($this->alt_option_name);

        return $instance;
    }

    function flush_widget_cache() {
        wp_cache_delete($this->alt_option_name, 'widget');
    }

    // Form
    public function form($instance) {
        $title = isset($instance['title']) ? $instance['title'] : '';
        $widget_description = isset($instance['widget_description']) ? $instance['widget_description'] : '';
        $widget_link = isset($instance['widget_link']) ? $instance['widget_link'] : '';
        $docs = isset($instance['docs']) ? $instance['docs'] : '';
        $data = json_decode($instance['data'], true);

        preg_match('/.*?-([0-9]+)$/i', $this->id, $matches);
        ?>

        <p>
            <label for="<?php echo $this->get_field_name('title'); ?>"><?php _e('Title:'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo htmlspecialchars($title); ?>" />
        </p>

        <p>
            <label for="<?php echo $this->get_field_name('widget_description'); ?>"><?php _e('Description :'); ?></label> <br>
            <textarea class="htmleditor_widgeted" name="<?php echo $this->get_field_name('widget_description'); ?>" id="<?php echo $this->get_field_name('widget_description'); ?>"><?php echo $widget_description; ?></textarea>
        </p>

        <p>
            <label for="<?php echo $this->get_field_name('widget_link'); ?>">Renvoi (lien)</label>
            <input class="widefat" id="<?php echo $this->get_field_id('widget_link'); ?>" name="<?php echo $this->get_field_name('widget_link'); ?>" type="text" value="<?php echo htmlspecialchars($widget_link); ?>" />
        </p>
        <div>
            <label for="ex-attachment-add-fieldset">Document :</label> <a class="button-secondary ex-attachment-add-fieldset" id="ex-attachment-add-fieldset" href="#">Ajouter un document</a>
        </div>

        <ul class="ex-attachments sortable list">
            <li class="default">
                <span>
                    <a class="up" href="#"></a>
                    <a class="down" href="#"></a>
                </span>
                <div class="widget-container-inline">
                    <a target="_blank" class="a-link widget-inline" ></a>
                    <a href="#" class="remove widget-inline"></a>
                    <input name="<?php echo esc_attr($this->get_field_name('data')); ?>[]" type="hidden" class="link" value="" />
                </div>
            </li>
            <?php if (!empty($data)): ?>
            <?php foreach ($data as $key => $value): ?>
                    <li>
                        <span>
                            <a class="up" href="#"></a>
                            <a class="down" href="#"></a>
                        </span>
                        <div class="widget-container-inline">
                            <a target="_blank" class="a-link widget-inline" href="<?php echo $value['link']; ?>"><?php echo $value['name']; ?></a>
                            <a class="remove remove_attachement_widget widget-inline"></a>
                            <input name="<?php echo esc_attr($this->get_field_name('data')); ?>[]" type="hidden" class="link" value='<?php echo json_encode($value); ?>' />
                        </div>
                    </li>
                <?php endforeach; ?>
        <?php endif; ?>
        </ul>
        <hr>
        <?php $ancre = ($instance["ancre"]) ? $instance["ancre"] : dh_get_code(8, 'defaut'); ?>
        <p>
            <label for="<?php echo $this->get_field_name('ancre'); ?>"><?php _e('Ancre :'); ?></label> Préciser le titre entre les "" de title=""<br>
            <input class="widefat" id="<?php echo $this->get_field_id('ancre'); ?>" name="<?php echo $this->get_field_name('ancre'); ?>" type="text" value="<?php echo htmlspecialchars($ancre); ?>" />
            Copiez le code ci-dessus pour l'intégrer dans le contenu de l'article.
        </p>


        <br><br>
        <?php
    }

}

register_widget('Dh_Widget_Perso_Encart');
add_action('widgets_init', function() {
    register_widget('Dh_Widget_Perso_Encart');
});