<?php get_header(); ?>

<?php
$colors_category = get_option("category_colors");
$active_color = $colors_category[the_category_ID(false)];
$filigrane = get_field("avec_filigrane_", "category_" . the_category_ID(false));
$surcharge_filigrane_css = ($filigrane == 0) ? ".bg-repeat{background:none !important;}" : "";

$url_article = get_field("url_article_de_reference", "category_" . the_category_ID(false));

function getLinkEnAvant($url_article) {
    echo (!empty($url_article)) ? $url_article : the_permalink();
}
?>

<style>
    .category_color{
        background-color:<?php echo $active_color; ?> !important;
    }
    .font-color-category{
        color:<?php echo $active_color; ?> !important;
    }
    <?php echo $surcharge_img_fond; ?>
    <?php echo $surcharge_filigrane_css; ?>
</style>

<section class="categorie">
    <a href="<?php echo getLinkEnAvant($url_article); ?>"><h1 class="category_color"><?php echo single_cat_title(); ?></h1></a>
    <article>
        <?php
        $subtitle = get_field("sous_titre_categorie", "category_" . the_category_ID(false));
        if (!empty($subtitle)) {
            ?>
            <div class="encadre-titre">
                <h2>
                    <a href="<?php echo getLinkEnAvant($url_article); ?>" alt="Lire l'article" title="Lire l'article">
                        <?php echo dh_filtre_texte_bold($subtitle); ?>
                    </a>
                </h2>
            </div>
        <?php }
        
        $content = get_field("chapo_de_la_categorie", "category_" . the_category_ID(false));
        if (!empty($content)) {
            ?>
            <div class="content">
                <?php echo $content; ?> 

                <?php if (get_field('afficher_lire_la_suite', "category_" . the_category_ID(false))) { ?>
                    <a href="<?php echo getLinkEnAvant($url_article); ?>">Lire la suite</a>
                <?php } ?>

            </div>
        <?php } ?>
    </article>

    <?php if (have_posts()): ?>
        <div class="post-in-category">
            <span class="icon summary-icon"></span>
            <div class="summary_entries">
                <?php
                while (have_posts()) : the_post();
                    ?>
                    <div class="entry">
                        <a class="fastclick" href="<?php the_permalink(); ?>">
                            <h2 class="subtitle font-color-category"><?php echo get_field("sous-titre"); ?></h2>
                            <p><?php the_title(); ?></p>
                        </a>
                    </div>
                <?php endwhile; ?>
            </div>
        </div>

        <div class="first-post-category">
            <a href="<?php echo $url_article; ?>" class="category_color">
                <span class="icon"></span>
            </a>
        </div>
    <?php endif; ?>
</section>
<?php get_footer(); ?>