<?php 

if ( ! function_exists( 'get_field') ){
    //echo "Veuillez Activer : <b><a href='/wp-admin/plugins.php?plugin=advanced-custom-fields%2Facf.php'>Advanced Custom Field</a></b> despuis le menu 'extensions'";
}
if ( ! function_exists( 'register_numero_taxonomy')) :
    add_action( 'init', 'register_numero_taxonomy', 0 );
function register_numero_taxonomy(){
    
    // Add new taxonomy, make it hierarchical (like categories)
    $labels = array(
            'name'              => "Numéros",
            'singular_name'     => "Numéro",
            'search_items'      => "Ancien numéro",
            'all_items'         => "Tous les numéros",
            'parent_item'       => "Numéro parent",
            'parent_item_colon' => "Numéro parent",
            'edit_item'         => "Editer un numéro",
            'update_item'       => "Mettre à jour le numéro",
            'add_new_item'      => "Ajouter un numéro",
            'new_item_name'     => "Ajouter un nouveau numéro",
            'menu_name'         => "Numéro",
    );

    $args = array(
            'hierarchical'      => true,
            'labels'            => $labels,
            'show_ui'           => true,
            'show_admin_column' => true,
            'query_var'         => true,
            'public'            => true,
            'rewrite'           => array( 'slug' => 'numero' ),
    ); register_taxonomy( 'numero', 'post', $args );
} endif;

// Rend le numéro en cours
function getCurrentNumero(){
    global $wpdb,$wp_taxonomies;
    
    if((int)$_GET['id_num'] != 0){
        $id = (int)$_GET['id_num'];
        $selector = "id";
    }else{
        $id = date('Ym');
        $selector = "date";
       
        if((int)$_SESSION['dh_num_mag'] >=1){
            $id = (int)$_SESSION['dh_num_mag'];
            $selector = "id";
        }
    } $id_num = (int)$_SESSION['dh_num_mag'];
    
    $numeros = get_terms(array("taxonomy" => "numero",'hide_empty' => false));
    if(!empty($numeros)){
        
        foreach($numeros as $k => $numero){
            
            $numeros[$k]->id_acf = $numero->taxonomy."_".$numero->term_id;
            $numeros[$k]->date_pub = get_field('date_de_publication', $numeros[$k]->id_acf);
            
            if( $selector == "date"
                && substr($numeros[$k]->date_pub,0,6) == $id){
                    $current_numero = $numeros[$k];
            }
            
            if($numeros[$k]->term_id == $id
                && $selector == "id"){
                    $current_numero = $numeros[$k];
            }
        }
        
        // Si les dates ne correspondent pas, on prend le dernier by date_pub
        if(empty($current_numero)){
            foreach($numeros as $numero){
                
                if(substr($numero->date_pub,0,6) > date('Ym'))
                    continue;
                
                $numeros_publish[substr($numero->date_pub,0,6)] = $numero->term_id;
            }
            
            // Order array
            ksort($numeros_publish);
            $keys = array_keys($numeros_publish);
            $last_key = $keys[count($keys)-1];
            $id_num = $numeros_publish[$last_key];
            
            // Fetch numero
            $current_numero = get_term_by('id', $id_num, 'numero');
            $current_numero->id_acf = "numero_".$id_num;
            $_SESSION['dh_num_mag'] = $current_numero->term_id;
        }
        
        if($id_num != $id && $selector =="id")
            $_SESSION['dh_num_mag'] =  $current_numero->term_id;
    }
    return($current_numero);
}

/*
usort($numeros, 'dh_comparer_obj');
function dh_comparer_obj($a, $b) {
  return strcmp($a->date_de_publication, $b->date_de_publication);
} */

function dh_filterByNumero($query){
   
    if( ($query->is_main_query()
            && $_GET["post_type"] !="acf"
            && $_GET["post_type"] !="page"
            && $_GET["post_type"] !="slideshow")
            //&& !is_admin()
        ){
        $current_numero = getCurrentNumero();
        
        // Filtre by lang search
        if(isset($_GET["s"])) $filtre_lang = $query->query_vars["tax_query"][0];
        else  $filtre_lang = "";
        
        $taxquery = array(
            'orderby' => 'menu_order',
            'order' => 'ASC',
            'relation' => 'and',
            array(
                'taxonomy' => 'numero',
                'field' => 'term_id',
                'terms' => array( $current_numero->term_taxonomy_id ),
            ),
            $filtre_lang,
        );
       
        if($_GET['id_num'] == "all" || $_SESSION['dh_num_mag'] == "all"){
            $_SESSION['dh_num_mag'] == "all";
        }else{
            $query->set( 'tax_query', $taxquery );
        }
    }
} add_action("pre_get_posts", "dh_filterByNumero");


// Tree menu array
function dh_get_tree_menu_nav(){
    $current_num = getCurrentNumero();
    $tree_menu[] = array("url" => get_bloginfo("url"), "ID" => -1, "obj" => "blank");
    $tree_menu[] = array("url" => get_bloginfo("url"), "ID" => 0, "obj" => "blank");
    
    
    $theme_locations = gm_get_theme_menu_name("submenu");
    if(!empty($theme_locations)){
        $links = wp_get_nav_menu_items($theme_locations);
        
        if(!empty($links)){
            foreach($links as $link){
                
                // Link page
                if($link->object == "page"){
                    $tree_menu[] = array("url" => $link->url, "ID" => $link->object_id, "obj" => "page", "name" => $link->title);
                }
                
                // Lien categorie + get posts
                if($link->object == "category"){
                    $tree_menu[] = array("url" => $link->url, "ID" => $link->object_id, "obj" => "category", "name" => $link->title); // Add link category
                   
                    // Lien sur all articles ORDER
                    $posts = get_posts(array(
                        'post_type' => 'post',
                        'numberposts' => -1,
                        'orderby' => 'menu_order',
                        'order' => 'ASC',
                        'tax_query' => array(
                            array(
                                'taxonomy' => 'category',
                                'field' => 'term_id',
                                'terms' => $link->object_id,
                            ),array(
                                'taxonomy' => 'numero',
                                'field' => 'term_id',
                                'terms' => $current_num->term_id,
                            ),
                        )
                    )); //$posts = get_posts(array("category" => $link->object_id));
                    
                    if(!empty($posts)){
                        foreach($posts as $post){
                            $link_menu = get_permalink($post->ID);
                            if(substr($link_menu,-1) !="/") $link_menu.="/";
                            $tree_menu[] = array("url" => get_permalink($post->ID), "ID" => $post->ID, "obj" => "post", "name" => $post->post_title);
                        }
                    }
                }
            }
        }
    }
    //get($tree_menu);
    return ( (array) $tree_menu);
}

// Rend la liste des post 
function dh_get_list_post_id($num){
    $args = array(
        'post_type' => 'post',
        'orderby' => 'menu_order',
        'order' => 'ASC',
        'posts_per_page' => 999,
        'tax_query' => array(
            array(
                'taxonomy' => 'numero',
                'field' => 'term_id',
                'terms' => $num,
            ),
        )
    );
    
    $posts = query_posts( $args );
    if(!empty($posts)){
        foreach($posts as $post){
            $liste_post_id[] = $post->ID;
        }
    }
  
    return($liste_post_id);
}