<?php

require_once dirname( __FILE__ ) . '/TinyCompressSharedTestCase.php';

class Tiny_Compress_Fopen_Test extends Tiny_Compress_Shared_TestCase {
	public static function set_up_before_class() {
		Tiny_PHP::$client_supported = false;
	}

	public function set_up() {
		stream_wrapper_unregister( 'https' );
		stream_wrapper_register( 'https', 'MockHttpStreamWrapper', STREAM_IS_URL );
		MockHttpStreamWrapper::clear();
		parent::set_up();
	}

	public function tear_down() {
		parent::tear_down();
		stream_wrapper_restore( 'http' );
	}

	protected function register( $method, $url, $details ) {
		MockHttpStreamWrapper::register( $method, $url, $details );
	}

	public function test_should_return_fopen_compressor_if_client_not_supported() {
		$this->assertInstanceOf( 'Tiny_Compress_Fopen', $this->compressor );
	}

	public function test_can_create_key_should_return_false() {
		$this->assertSame( false, $this->compressor->can_create_key() );
	}
}
