<?php get_header(); ?>
<?php
    $current_numero = getCurrentNumero();
    $url_logo_by_numero = get_field('petit_logo', $current_numero->id_acf);
    $numerotation = get_field("numerotation", $current_numero->id_acf);
    $num_colors = get_option('numero_colors');
    $active_color = $num_colors[$current_numero->term_id];
?>

<style>
div.bg-repeat{
    background: url("<?php echo get_template_directory_uri();?>/img/bg_whitetrame.png") center fixed;
    width:100%;
    height:100%;
    position:fixed;
    display:block;
    left:0;
    top:0;
    z-index: -1;
}
</style>
    <!-- section -->
        <section class="edito">
            <h1 class="color-current-numero-bg"><?php the_title(); ?></h1>


            <?php if (have_posts()): while (have_posts()) : the_post(); ?>
                <div class="chapo">
                    <div class="img">
                        <?php echo get_the_post_thumbnail( $post, 'full' );?>
                    </div>
                    <?php
                        // Sous-titre
                        $sub_title = get_field("sous-titre");
                        if(isset($sub_title))
                            echo "<h2 class='color-current-numero'>".dh_filtre_texte_bold($sub_title)."</h2>";
                    ?>
                </div>

                <!-- article -->
                <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

                    <?php
                        // Chapo
                        $chapo = get_field("chapo_de_larticle");
                        if(isset($chapo))
                            echo "<div class='chapo'>".$chapo."</div>";
                    ?>

                    <?php the_content(); ?>

                    <?php // comments_template( '', true ); // Remove if you don't want comments ?>

                </article>
                <!-- /article -->

                <div class="author">
                    <?php
                        // Chapo
                        $auteur = get_field("auteur");
                        if(isset($auteur))
                            echo "<p>".dh_filtre_texte_bold($auteur)."</p>";
                    ?>
                </div>

                <nav class="footer_navigation">
                    <?php
                        // Get Arbo
                        $tree_menu = dh_get_tree_menu_nav();
                        $id_item = get_the_ID(false);

                        // Set link
                        if(!empty($tree_menu)){
                            $key = dh_find_key_array_by_value($tree_menu,$id_item);
                            $max = count($tree_menu);

                            $prev = $key-1;
                            if($prev < 0){
                                $prev = $max -1;
                            }

                            $next = $key +1;
                            if($next > ($max-1)){
                                $next = 0;
                            }

                            $link_prev = $tree_menu[$prev];
                            $link_current = $tree_menu[$key];
                            $link_next = $tree_menu[$next];
                        }
                    ?>
                    <a tabindex="-1" href="<?php print($link_prev['url']); ?>" class="prev_post">
                        <span class="icon"></span>
                        <span class="text"><?php print($link_prev['name']); ?></span>
                    </a>

                    <a tabindex="-1" href="<?php print($link_next['url']); ?>" class="next_post">
                        <span class="text"><?php print($link_next['name']); ?></span>
                        <span class="icon"></span>
                    </a>
                </nav>

                <div class="edit-post-edito">
                    <i class="glyphicon glyphicon-pencil"></i>
                    <?php edit_post_link(); ?>
                </div>

        <?php endwhile; ?>

        <?php else: ?>

                <!-- article -->
                <article>
                    <h2><?php _e( 'Sorry, nothing to display.', 'html5blank' ); ?></h2>
                </article>
                <!-- /article -->
        <?php endif; ?>

        </section>
        <!-- /section -->
<?php get_footer(); ?>