<?php
/**
 * Template Name: Edito
 **/
?>
<?php get_header(); ?>

<style> 
div.bg-repeat{
    background: url("<?php echo get_template_directory_uri();?>/img/bg_whitetrame.png") center fixed;
    width:100%;
    height:100%;
    position:fixed;
    display:block;
    left:0;
    top:0;
    z-index: -1;
}
</style>

        <!-- section -->
        <section class="edito">
            
            <div class="img_edito">
                <?php echo get_the_post_thumbnail( $post, 'full' );?>
            </div>
            
            <?php if (have_posts()): while (have_posts()) : the_post(); ?>

                <!-- article -->
                <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                    
                    <h4 class="edito_title"><?php the_title(); ?></h4>
                    
                    <?php
                        // Sous-titre
                        $sub_title = get_field("sous-titre");
                        if(isset($sub_title))
                            echo "<h1 class='libelle_edito'>".dh_filtre_texte_bold($sub_title)."</h1>";
                    ?>
                    
                    <?php
                        // Chapo
                        $chapo = get_field("chapo_de_larticle");
                        if(!empty($chapo))
                            echo "<div class='chapo'>".$chapo."</div>";
                    ?>

                    <?php the_content(); ?>

                    <?php
                    // Get Arbo
                    $tree_menu = dh_get_tree_menu_nav();
                    $id_item = get_the_ID(false);

                    // Set link
                    if (!empty($tree_menu)) {
                        $key = dh_find_key_array_by_value($tree_menu, $id_item);
                        $max = count($tree_menu);

                        $prev = $key - 1;
                        if ($prev < 0) {
                            $prev = $max - 1;
                        }

                        $next = $key + 1;
                        if ($next > ($max - 1)) {
                            $next = 0;
                        }

                        $link_prev = $tree_menu[$prev];
                        $link_current = $tree_menu[$key];
                        $link_next = $tree_menu[$next];
                    }
                    ?>
                    
                    <div class="contextual_nav">
                        <div class="previous">
                            <?php
                            if (!empty($link_prev['name']))
                                echo "<a href='" . $link_prev['url'] . "'id='prev'><span class='inner'><span class='text'>" . $link_prev['name'] . "</span><span class='icon'></span></a>";
                            ?>
                        </div>
                        <div class="next">
                            <?php
                            if (!empty($link_next['name']))
                                echo "<a href='" . $link_next['url'] . "' id='next'><span class='inner'><span class='text'>" . $link_next['name'] . "</span><span class='icon'></span></a>";
                            ?>
                        </div>
                    </div>

                </article>
                <!-- /article -->

                
                <?php
                    // Chapo
                    $auteur = get_field("auteur");
                    if(!empty($auteur)){
                        echo '<div class="author">';
                            echo "<p>".dh_filtre_texte_bold($auteur)."</p>";
                        echo '</div>';
                    }
                ?>

               

        <?php endwhile; ?>

        <?php else: ?>

                <!-- article -->
                <article>
                    <h2><?php _e( 'Sorry, nothing to display.', 'html5blank' ); ?></h2>
                </article>
                <!-- /article -->
        <?php endif; ?>

        </section>
        <!-- /section -->


<?php get_footer(); ?>