<?php
/**
 * Template Name: Sommaire
 **/
?>
<?php get_header(); ?>

<?php
    // Init var
    $current_numero = getCurrentNumero();
    $tree_menu = dh_get_tree_menu_nav();
    $cat_colors = get_option('category_colors');
?>
<style>
div.bg-repeat{
    background: url("<?php echo get_template_directory_uri();?>/img/bg_whitetrame.png") center fixed;
    width:100%;
    height:100%;
    position:fixed;
    display:block;
    left:0;
    top:0;
    z-index: -1;
}
</style>




<main role="main">
        <!-- section -->
        <section class="sommaire">
            <h1 class="color-current-numero-bg"><?php the_title(); ?></h1>
            
            <div class="header-numero">
                <div id="logo_container">
                    <?php 
                        $url_logo_by_numero = get_field('petit_logo_presentation', $current_numero->id_acf); // Logo Actualité + Principal (en haut à gauche)
                        // Logo de la ville 
                        if(!empty($url_logo_by_numero["sizes"]["medium_large"])){
                            $legende = (!empty($url_logo_by_numero["title"])) ? $url_logo_by_numero["title"] : "Logo officiel";
                            echo "<img id='logo' src='".$url_logo_by_numero["sizes"]["medium_large"]."' alt='".$legende."' title='".$legende."'>";
                        }
                    ?>
                </div>
                
                <div id="header_numero" class="color-current-numero">
                    <span id="issue_prefix">N°</span><?php echo get_field("numerotation",$current_numero->id_acf); ?><br />
                    <span id="issue_month"><?php echo $current_numero->name; ?></span>
                </div>
                <div style="clear:both"></div>
            </div>
                
            
            <ul id="liste_sommaire">
                <?php foreach($tree_menu as $link){
                    $img ="";
                    if($link["obj"] == "blank") continue;
                    
                    if($link["obj"] == "category"){
                        $item = get_category($link["ID"]);
                        
                        // Var
                        $title = $item->cat_name;
                        $content = get_field("sous_titre_categorie", "category_".$link["ID"]);
                        $img_cat = get_field("image_de_fond", "category_".$link["ID"]);
                        $img = $img_cat['url'];
                        // Color 
                        $cat_colors_css = "color:".$cat_colors[$link["ID"]]." !important;";
                        
                    }else{
                        $item = get_post($link["ID"]);
                        
                        // Test remonte sommaire 
                        if($link["obj"] == "post"){
                            $test_dans_sommaire = get_field("dans_le_sommaire", $link["ID"]);
                            if($test_dans_sommaire == 0) continue;
                        }
                        
                        // Var
                        $title = $item->post_title;
                        $content = get_field("sous-titre", $item->ID);
                        $img = wp_get_attachment_image_src(get_post_thumbnail_id( $item->ID), 'thumbnail');
                        
                        if(is_array($img))
                            $img=$img[0];
                    }
                ?>
                    <li class="summary-entry list-summary-<?php echo $link["obj"];?>">
                        <a class="regular_click" href="<?php echo $link['url'];?>" alt="<?php echo $link['name']; ?>" title="<?php echo $link['name']; ?>">
                            <?php if($link["obj"] !="post" ){ ?> 
                                <span class="image" style="background:url('<?php echo $img;?>')no-repeat center center transparent; background-size:cover;">
                            <?php } ?>
                            </span>
                            <span class="excerpt">
                                <span class="h4 color-current-numero" style="<?php echo $cat_colors_css;?>"><?php echo $title;?></span> <br />
                                <span class="chapo"><?php echo dh_filtre_texte_bold($content);?></span>
                                <?php if($link["obj"] !="post" ){ ?> 
                                    <span class="icon"></span>
                                <?php } ?>
                            </span>
                            <span class="clearfloat"></span>
                        </a>
                        <!-- Sous menu du sommaire -->
                        <ul class="subs"> </ul>
                        <div style="clear:both"></div>
                    </li>
                <?php } ?>
            </ul>
        </section>
        <!-- /section -->
</main>
<?php get_footer(); ?>