<?php
//------------------------------------------------------------------------------
//    Widget Citation       
//------------------------------------------------------------------------------   
    
class Dh_Widget_Perso_Citation extends WP_Widget{
    
    public function __construct(){
        parent::__construct('dh_citation', 'Citation', array('description' => 'Widget Citation'));
    }
    
    // Front view
    public function widget($args, $instance){
        echo $args['before_widget'];
            echo "<div class='wrapper-widget border-active widget-quote'>";
            // Lien ancre
            $params = explode('=',$instance["ancre"]);
            if(!empty($params)){
                $code_ancre = substr($params[1], 0,8);
                echo '<a name="'.$code_ancre.'">&nbsp;</a>';
            }
                echo '<div class="open_quote"></div>';
                    echo "<h4>".$instance['title']."</h4>";
                    echo "<p class='text-quote'>".$instance["description"]."</p>";
                    echo "<p class='auteur-quote'>".$instance['auteur']."</p>";
                echo '<div class="close_quote"></div>';
            echo "</div>"; // wrapper
        echo $args['after_widget'];
    }
    
    // Form
    public function form($instance){
        
        $title = isset($instance['title']) ? $instance['title'] : '';
        $auteur = isset($instance['auteur']) ? $instance['auteur'] : '';
        $description = isset($instance['description']) ? $instance['description'] : '';
        
        ?>
        <p>
            <label for="<?php echo $this->get_field_name( 'title' ); ?>">Titre :</label>
            <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo  htmlspecialchars($title); ?>" />
        </p>
        
        <p>
            <label for="<?php echo $this->get_field_name( 'auteur' ); ?>">Auteur :</label>
            <input class="widefat" id="<?php echo $this->get_field_id( 'auteur' ); ?>" name="<?php echo $this->get_field_name( 'auteur' ); ?>" type="text" value="<?php echo  htmlspecialchars($auteur); ?>" />
        </p>
        
        <p>
            <label for="<?php echo $this->get_field_name( 'description' ); ?>"><?php _e( 'Description :' ); ?></label> <br>
            <textarea class="htmleditor_widgeted" name="<?php echo $this->get_field_name( 'description' ); ?>" id="<?php echo $this->get_field_name( 'description' ); ?>"><?php echo $description;?></textarea>
        </p>
        
       <hr>
            <?php $ancre = ($instance["ancre"]) ? $instance["ancre"] : dh_get_code(8); ?>
            <p>
                <label for="<?php echo $this->get_field_name( 'ancre' ); ?>"><?php _e( 'Ancre :' ); ?></label> Ajouter ico=video ou ico=image ico=pdf avant "]" pour changer l'icone du lien rapide<br>
                <input class="widefat" id="<?php echo $this->get_field_id( 'ancre' ); ?>" name="<?php echo $this->get_field_name( 'ancre' ); ?>" type="text" value="<?php echo  htmlspecialchars($ancre); ?>" />
                Copiez le code ci-dessus pour l'intégrer dans le contenu de l'article.
            </p>
            <br><br>
        
        <?php
    }
}

register_widget('Dh_Widget_Perso_Citation');
add_action('widgets_init', function(){register_widget('Dh_Widget_Perso_Citation');});