<?php
/**
 * Template Name: Sommaire
 **/
?>
<?php get_header(); ?>

<?php
    // Init var
    $current_numero = getCurrentNumero();
    $tree_menu = dh_get_tree_menu_nav();
    $cat_colors = get_option('category_colors');
?>

<main role="main">
        <!-- section -->
        <section class="sommaire">
            <h1 class="color-current-numero-bg"><?php the_title(); ?></h1>
            
            <div class="header-numero">
                <div id="logo_container">
                    <?php 
                        $url_logo_by_numero = get_field('petit_logo', $current_numero->id_acf); // Logo Actualité + Principal (en haut à gauche)
                        // Logo de la ville 
                        if(!empty($url_logo_by_numero["sizes"]["medium_large"])){
                            $legende = (!empty($url_logo_by_numero["title"])) ? $url_logo_by_numero["title"] : "Logo officiel";
                            echo "<img id='logo' src='".$url_logo_by_numero["sizes"]["medium_large"]."' alt='".$legende."' title='".$legende."'>";
                        }
                    ?>
                </div>
                
                <div id="header_numero" class="color-current-numero">
                    <span id="issue_prefix">N°</span><?php echo get_field("numerotation",$current_numero->id_acf); ?><br />
                    <span id="issue_month"><?php echo $current_numero->name; ?></span>
                </div>
                <div style="clear:both"></div>
            </div>
                
            
            <ul id="liste_sommaire">
                <?php foreach($tree_menu as $link){
                    
                    if($link["obj"] == "blank") continue;
                    
                    if($link["obj"] == "category"){
                        $item = get_category($link["ID"]);
                        
                        // Var
                        $title = $item->cat_name;
                        $content = get_field("sous_titre_categorie", "category_".$link["ID"]);
                        $img = get_field("image_de_fond", "category_".$link["ID"]);
                        
                        // Color 
                        $cat_colors_css = "color:".$cat_colors[$link["ID"]]." !important;";
                        
                    }else{
                        $item = get_post($link["ID"]);
                        
                        // Test remonte sommaire 
                        if($link["obj"] == "post"){
                            $test_dans_sommaire = get_field("dans_le_sommaire", $link["ID"]);
                            if($test_dans_sommaire == 0) continue;
                        }
                        
                        // Var
                        $title = $item->post_title;
                        $content = get_field("sous-titre", $link["ID"]);
                        $img = wp_get_attachment_image_src(get_post_thumbnail_id( $link["ID"]), 'full');
                        $img_src=$img[0];
                    }
                ?>
                    <li class="summary-entry ">
                        <a class="regular_click" href="<?php echo $link['url'];?>" alt="<?php echo $link['name']; ?>" title="<?php echo $link['name']; ?>">
                            <span class="image" style="background:url('<?php echo $img_src;?>')no-repeat center center transparent; background-size:cover;">                            
                            </span>
                            <span class="excerpt">
                                <span class="h4 color-current-numero" style="<?php echo $cat_colors_css;?>"><?php echo $title;?></span> <br />
                                <span class="chapo"><?php echo dh_filtre_texte_bold($content);?></span>
                                <span class="icon"></span>
                            </span>
                            <span class="clearfloat"></span>
                        </a>
                        <!-- Sous menu du sommaire -->
                        <ul class="subs"> </ul>
                        <div style="clear:both"></div>
                    </li>
                <?php } ?>
                    
                        <div style="clear:both"></div>
            </ul>
            
                        <div style="clear:both"></div>
        </section>
        <!-- /section -->
        
                        <div style="clear:both"></div>
</main>

                        <div style="clear:both"></div>
<?php get_footer(); ?>