<?php
/**
 * Template Name: Edito
 **/
?>
<?php get_header(); ?>

        <!-- section -->
        <section class="edito">
            <h1 class="color-current-numero-bg"><?php the_title(); ?></h1>
            
                
            <?php if (have_posts()): while (have_posts()) : the_post(); ?>
                <div class="chapo">
                    <div class="img">
                        <?php echo get_the_post_thumbnail( $post, 'thumbnail' );?>
                    </div>
                    <?php
                        // Sous-titre
                        $sub_title = get_field("sous-titre");
                        if(isset($sub_title))
                            echo "<h2 class='color-current-numero'>".dh_filtre_texte_bold($sub_title)."</h2>";
                    ?>
                </div>
            
                <!-- article -->
                <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                    
                    <?php
                        // Chapo
                        $chapo = get_field("chapo_de_larticle");
                        if(isset($chapo))
                            echo "<p class='chapo'>".$chapo."</p>";
                    ?>
                    
                    <?php the_content(); ?>
                    
                    <?php // comments_template( '', true ); // Remove if you don't want comments ?>
                        
                </article>
                <!-- /article -->
                
                <div class="author">
                    <?php 
                        // Chapo
                        $auteur = get_field("auteur");
                        if(isset($auteur))
                            echo "<p>".dh_filtre_texte_bold($auteur)."</p>";
                    ?>
                </div>
                
                <nav class="footer_navigation">
                    <a tabindex="-1" href="" class="prev_post">
                        <span class="icon"></span>
                        <span class="text">Sommaire</span>
                    </a>
                    
                    <a tabindex="-1" href="" class="next_post">
                        <span class="text">Sommaire</span>
                        <span class="icon"></span>
                    </a>
                </nav>
                
                <div class="edit-post-edito">
                    <i class="glyphicon glyphicon-pencil"></i>
                    <?php edit_post_link(); ?>
                </div>
                
        <?php endwhile; ?>

        <?php else: ?>

                <!-- article -->
                <article>
                    <h2><?php _e( 'Sorry, nothing to display.', 'html5blank' ); ?></h2>
                </article>
                <!-- /article -->
        <?php endif; ?>

        </section>
        <!-- /section -->
    

<?php get_footer(); ?>