<?php get_header(); ?>

<?php
// Get option
$all_articles = get_field("articles_a_attacher");
$colors_category = get_option("category_colors");
$active_color = $colors_category[the_category_ID(false)];
$rbg_active_color = dh_hex2rgb($active_color);
$normal = "rgb(" . $rbg_active_color[0] . ", " . $rbg_active_color[1] . ", " . $rbg_active_color[2] . ");";
$dark = "rgba(" . $rbg_active_color[0] . ", " . $rbg_active_color[1] . ", " . $rbg_active_color[2] . ", 0.6);";
$category = get_the_category($post);
?>
<style>
    div.post-topic-child:nth-child(2n + 1){
        border-color: <?php echo $normal; ?> !important;
    }
    div.post-topic-child:nth-child(2n + 1) h5,
    div.post-topic-child:nth-child(2n + 1) h4 {
        color: <?php echo $normal; ?> !important;
    }
    
    div.post-topic-child:nth-child(2n){
        border-color: <?php echo $dark; ?> !important;
    }
    div.post-topic-child:nth-child(2n) h5,
    div.post-topic-child:nth-child(2n) h4 {
        color: <?php echo $dark; ?> !important;
    }
    
</style>
<main role="main" class="container-topic">
    <section class="wrapper-topic">
        <h1 class="title-cat" style="background-color:<?php echo $active_color; ?>"><?php echo $category[0]->name; ?></h1>
        <div class="post-topic-title">
            <div class="cover-excerpt">
                <h2><?php echo the_title(); ?></h2>
            </div>
        </div>

        <div class="post-topic-content">
            <?php if ($all_articles) { ?>
                <div class="post-topic-content">
                    <?php foreach ($all_articles as $article) { ?>

                        <?php $link = get_field("lien_sortant", $article->ID); ?>

                        <div class="post-topic-child">
                            <div class="post-topic-child-img">
                                <?php echo get_the_post_thumbnail($article, 'full'); ?>
                            </div>

                            <h5 class="post-topic-child-subtitle">
                                <?php
                                echo get_field("sous-titre", $article->ID);
                                ?>
                            </h5>
                            <h4 class="post-topic-child-title">
                                <?php
                                echo $article->post_title;
                                ?>
                            </h4>

                            <div class="post-topic-child-content">
                                <?php
                                echo get_field("chapo_de_larticle", $article->ID);
                                ?>
                            </div>

                            <?php if (!empty($link)) { ?>
                                <div class="post-topic-child-link-out">
                                    <a href="<?php echo $link; ?>" target="_blank">
                                        <span class="icone-en-savoir-plus"></span>
                                        En savoir plus
                                    </a>
                                </div>
                            <?php } ?>
                        </div>
                    <?php } ?>
                </div>
            <?php } ?>
        </div>


        <div style="clear:both"></div>
        <br><br><br><br>

        <!-- article -->
        <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
            <!-- post thumbnail -->
            <?php if (has_post_thumbnail()) : // Check if Thumbnail exists  ?>
                <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
                    <?php the_post_thumbnail(); // Fullsize image for the single post  ?>
                </a>
            <?php endif; ?>
            <!-- /post thumbnail -->



            <?php
            // Sous-titre
            $sub_title = get_field("sous-titre");
            if (isset($sub_title))
                echo "<h2>" . $sub_title . "</h2>";
            ?>

            <?php
            // Chapo
            $chapo = get_field("chapo_de_larticle");
            if (isset($chapo))
                echo "<p>" . $chapo . "</p>";
            ?>

            <?php the_content(); // Dynamic Content  ?>
            <?php
            if (is_user_logged_in()) {
                ?>
                <div class="edit-post-edito">
                    <i class="glyphicon glyphicon-pencil"></i>
                    <?php edit_post_link(); ?>
                </div>
            <?php } ?>
            <?php //comments_template(); ?>
        </article>
    </section>

    <!-- /article -->
</main>
<?php get_footer(); ?>