<?php /* Template Name: Sans Sidebar */ get_header(); ?>

    <main role="main" class="page-content-sans-sidebar">
            <!-- section -->
            <section>

            <h1 class="color-current-numero-bg"><?php the_title(); ?></h1>

            <?php if (have_posts()): while (have_posts()) : the_post(); ?>

            <article>

                <?php the_content(); ?>

                <?php comments_template( '', true ); // Remove if you don't want comments ?>

                <br class="clear">

                <?php
                    if (is_user_logged_in()) {
                        ?>
                        <div class="edit-post-edito">
                            <i class="glyphicon glyphicon-pencil"></i>
                            <?php edit_post_link(); ?>
                        </div>
                    <?php } ?>
            </article>

            <?php endwhile; ?>

            <?php else: ?>

                    <!-- article -->
                    <article>

                            <h2><?php _e( 'Sorry, nothing to display.', 'html5blank' ); ?></h2>

                    </article>
                    <!-- /article -->

            <?php endif; ?>

            </section>
            <!-- /section -->
    </main>

<?php //get_sidebar(); ?>

<?php get_footer(); ?>