<?php if (have_posts()): while (have_posts()) : the_post(); ?>

	<!-- article -->
	<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
            <a class="regular_click" href="<?php the_permalink(); ?>">    
                <span class="image">    
                    <?php if ( has_post_thumbnail()) : // Check if thumbnail exists ?>
                        <?php the_post_thumbnail(array(100,100)); // Declare pixel size you need inside the array ?>
                    <?php endif; ?>
                </span>
                <span class="excerpt">
                    <span class="h4" style="color:#ED154F"><?php the_title(); ?></span>
                    <?php 
                        // Sous-titre
                        $sub_title = get_field("sous-titre");
                        if(isset($sub_title))
                            echo "<h2>".$sub_title."</h2>";
                    ?>

                    <?php 
                        // Chapo
                        $chapo = get_field("chapo_de_larticle");
                        if(isset($chapo))
                            echo "<p>".$chapo."</p>";
                    ?>
                </span>
                <div style="clear:both"></div>

            </a>
	</article>
	<!-- /article -->
        <hr>
<?php endwhile; ?>

<?php else: ?>

	<!-- article -->
	<article>
		<h2><?php _e( 'Sorry, nothing to display.', 'html5blank' ); ?></h2>
	</article>
	<!-- /article -->

<?php endif; ?>
