(function ($, root, undefined) {
    $(function () {

        //----------------------------------------------------------------------
        //      MENUS
        //----------------------------------------------------------------------
        // Remonte le menu haut
        $( "i.ico-hide-menu" ).click(function(){
            if ($( this ).css( "transform" ) == 'none' ){
                $(this).css("transform","rotate(180deg)");
                $("header").slideUp();
            }else{
                $(this).css("transform","");
                $("header").slideDown();
            }
        });

        // Icone recherche
        $( "button.search-submit" ).click(function(event){
            $("form.search").submit(function(e){
                if($("div.search-input-animated").hasClass("search-input-animated-open")){
                    return true;
                }else{
                    $("div.search-input-animated").addClass("search-input-animated-open");
                    $(".search-input").focus();
                    return false;
                }
            });
        });

        // Menu actualité
        setTimeout(function(){
            $("div.cover-summary").addClass("actu-close");
        }, 3000);

        $(".issue-summary-wrapper").click(function(event){
            if($("div.cover-summary").hasClass("actu-close")){
                $("div.cover-summary").removeClass("actu-close");
            }else{
                $("div.cover-summary").addClass("actu-close");
            }
        });

        // Social share
        $(".share-ico").click(function(event){
            if($(".submenusocial").hasClass("share-open")){
                $(".submenusocial").removeClass("share-open");
            }else{
                $(".submenusocial").addClass("share-open");
            }
        });

        // Pop-up
        $(".popup-opener").each(function(){
            $(this).fancybox();
        });

        // Catégorie
        $(".post-in-category").hover(function(){
            if($(this).hasClass("deployed")){
                $(this).removeClass("deployed");
            }else{
                $(this).addClass("deployed");
            }
        });

        // Gallery
        $(".fancybox-button").fancybox({
            prevEffect		: "none",
            nextEffect		: "none",
            closeBtn		: true
        });

        // Link
        var prev_link = $("li.navigation-post-previous a");
        var next_link = $("li.navigation-post-next a");
        $('.wrap-page').hammer().on({
            'swipeleft': function (ev){
                $(location).attr('href',next_link.attr("href"));
                moveToTheLeft();
            },
            'swiperight': function (){
                $(location).attr('href',prev_link.attr("href"));
                moveToTheRight();
            }
        });

        //Navigation au clavier
        $('body').keydown(function(e){
            if( e.keyCode == 37 ){
                $(location).attr('href',prev_link.attr("href"));
                moveToTheRight();
            }
            else if(e.keyCode == 39){
                $(location).attr('href',next_link.attr("href"));
                moveToTheLeft();
            }
        });

        //Animation à l'ouverture d'une page
        // function moveToTheRight(){
            // $('.wrap-page').animate({
                // marginLeft: '+=3000'
            // }, 1000);
        // }

        // function moveToTheLeft(){
            // $('.wrap-page').animate({
                // marginLeft: '-=3000'
            // }, 1000);
        // }

        // Animation
        $(".opener-aside, .closer-aside").click(function(){
            if($(".format-image-close").hasClass("format-image-open")){
                $(".format-image-close").removeClass("format-image-open");
            }else{
                $(".format-image-close").addClass("format-image-open");
            }
        });
        //FORMAT IMAGES
        $('.container-format-image').find('.format-image-close').addClass('format-image-open');
        setTimeout(function(){ $('.container-format-image').find(".format-image-close").removeClass("format-image-open"); }, 5000);

        // Scrool To encart
        $('a[href^="#"]').click(function(){
            var id = $(this).attr("href").replace("#","");
            var offset = $("a[name="+id+"]").offset().top;
            var menus = $("header").height() + $("#subnav").height();
            $('aside.sidebar').animate({scrollTop: offset - menus}, 'slow');
            return false;
        });

        // Légende au survol image
        $(".tooltip-legend").each(function(){ $(this).wrapAll("<div class='container-legend'></div>");});    // Container
        $(".container-legend").mouseover(function(e){
            var legend = $(this).find(".legends-img");
            var content_legend = $(this).find("img").attr("rel");
            if(!legend.length){$(this).append("<div class='legends-img'>"+content_legend+"</div>");}
            $(this).find("div.legends-img").stop().fadeIn();
        }); $(".container-legend").mouseout(function(e){ $(".legends-img").stop().fadeOut();}); // Hide

        // Repositionner
        repositionner();
        $(window).resize(function(){ repositionner(); });
        function repositionner(){
            heightEcran = $(window).height();
            heightContainer = heightEcran - 91;
            $(".stop-fluid").css("height",heightContainer+"px");
        }
        
        // LANG sur 2 CARAC
        $('ul#menu-traduction > li > a').each(function(){
            var lang = $(this).attr("lang");
            var code_lang = lang.substr(3,5);
            if(code_lang =='US') var code_lang = "EN";
            $(this).html(code_lang);
        });
        
    });
})(jQuery, this);
