<!DOCTYPE html>
<html <?php language_attributes(); ?> class="full no-js">
	<head>
		<meta charset="<?php bloginfo('charset'); ?>">
		<title><?php wp_title(''); ?><?php if(wp_title('', false)) { echo ' :'; } ?> <?php bloginfo('name'); ?></title>

                <link href="<?php echo get_template_directory_uri(); ?>/img/icons/favicon.ico" rel="shortcut icon">
                <link href="<?php echo get_template_directory_uri(); ?>/img/icons/touch.png" rel="apple-touch-icon-precomposed">

		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
		<meta name="description" content="<?php bloginfo('description'); ?>">

                <link rel="stylesheet" type="text/css" href="<?php echo get_template_directory_uri(); ?>/css/bootstrap.css">
                <link rel="stylesheet" type="text/css" href="<?php echo get_template_directory_uri(); ?>/css/bootstrap-theme.css">
                <link rel="stylesheet" type="text/css" href="<?php echo get_template_directory_uri(); ?>/css/portfolio.css">
                <link rel="stylesheet" type="text/css" href="<?php echo get_template_directory_uri(); ?>/css/site.css">

		<?php wp_head(); ?>
        <script>
        // conditionizr.com
        // configure environment tests
        conditionizr.config({
            assets: '<?php echo get_template_directory_uri(); ?>',
            tests: {}
        }); </script>

	</head>
	<body <?php body_class(); ?>>
        <div class="bg-repeat"> </div>

        <?php
            $current_numero = getCurrentNumero();
            $num_colors = get_option('numero_colors');
            $active_color = $num_colors[$current_numero->term_id];
            $bg = get_field("image_de_couverture",$current_numero->id_acf);
        ?>

        <style scoped>
            body{
                background: url(<?php echo $bg["sizes"]["large"];?>) no-repeat center fixed;
                -webkit-background-size: cover;
                background-size: cover;
            }

            nav.navbar{
                background-color:<?php echo $active_color;?>;
            }
            span.count{
                background-color:<?php echo $active_color;?>;
            }

            .color-current-numero{
                color: <?php echo $active_color;?> !important;
            }
            .color-current-numero-bg{
                background-color: <?php echo $active_color;?> !important;
            }
        </style>

<?php
    // Get Arbo
    $tree_menu = dh_get_tree_menu_nav();

    // Get id current
    if(is_single()){ $id_item = get_the_ID(false); }
    else{  $id_item = the_category_ID(false); }
    if(is_page()){ $id_item = $post->ID; }
    if(is_front_page()){ $id_item = 0; }

    // Set link
    if(!empty($tree_menu)){
        $key = dh_find_key_array_by_value($tree_menu,$id_item);
        $max = count($tree_menu);

        $prev = $key-1;
        if($prev < 0){
            $prev = $max -1;
        }

        $next = $key +1;
        if($next > ($max-1)){
            $next = 0;
        }

        $link_prev = $tree_menu[$prev]['url'];
        $link_current = $tree_menu[$key]['url'];
        $link_next = $tree_menu[$next]['url'];
    }
    
?>

<header id="header_mobile">
    <nav class="navbar navbar-inverse navbar-static-top" role="navigation">
       <div class="navbar-header">
           <button type="button" class="navbar-toggle collapsed pull-left" data-toggle="collapse" data-target="#main-navigation">
               <span class="sr-only">Toggle navigation</span>
               <span class="icon-bar"></span>
               <span class="icon-bar"></span>
               <span class="icon-bar"></span>
           </button>
       </div>
       <div class="collapse navbar-collapse " id="main-navigation">

          <div id="subnav" class="row">
              <ul class="ico-menu">
                  <li id="ico_menu_1"><?php get_template_part('searchform'); ?></li>
                  <li id="ico_menu_2" <?php if(is_home() || is_front_page()){ echo "style='border-bottom:5px solid ".$active_color.";'"; }; ?> ><a href="<?php echo get_site_url();?>" class="ico-home"></a></li>
                  <li id="ico_menu_3"><div class="ico-sommaire"><a href="<?php echo get_permalink(290);?>">Sommaire</a></div></li>
              </ul>
               <?php wp_nav_menu( array( 'theme_location' => 'submenu' ) ); ?>
          </div>
          <?php  //echo do_shortcode("[DH_SOCIAL_SHARE prev=".$link_prev." current=".$link_current." next=".$link_next."]"); ?>

           <?php wp_nav_menu(array( 'theme_location' => 'header-menu')); ?>
        </div>

        <div id="lang-navigation">
           <?php wp_nav_menu( array( 'theme_location' => 'langmenu' ) ); ?>
        </div>
   </nav>
</header>
        <!-- <a href="#"><i class='ico-hide-menu' style="background-color:<?php echo $active_color;?>"></i></a> -->



        <div class="container-fluid stop-fluid wrap-page">