<?php
//------------------------------------------------------------------------------
//    Widget Publicite       
//------------------------------------------------------------------------------   
    
class Dh_Widget_Perso_Embed extends WP_Widget{
    
    public function __construct(){
        parent::__construct('dh_embed', 'Objet embed', array('description' => 'Widget Objet embed'));
        add_action('admin_enqueue_scripts', array($this, 'enqueue_upload_media'));
    }
    
    // ADD JS / CSS
    public function enqueue_upload_media(){
        if(!is_admin())
            return;
        
        wp_enqueue_media();
        wp_enqueue_script('upload_media_widget', get_template_directory_uri().'/widgets/js/upload-media.js', array('jquery'));
    }
    
    // Front view
    public function widget($args, $instance){
        echo $args['before_widget'];
        echo "<div class='wrapper-widget border-active widget-embed'>";
            // Lien ancre
            $params = explode('=',$instance["ancre"]);
            if(!empty($params)){
                $code_ancre = substr($params[1], 0,8);
                echo '<a name="'.$code_ancre.'">&nbsp;</a>';
            }
         
            if(strpos($instance['code_embed'],'dailymotion') || strpos($instance['code_embed'],'dai.ly')){
                $code_video = "dailymotion";
            }
            if(strpos($instance['code_embed'],'vimeo')){
                $code_video = "vimeo";
            }
            
            // Switch - url vidéo 
            switch($code_video){
                
                case "vimeo" :
                    $code_part = str_replace("https://vimeo.com","",$instance['code_embed']);
                    $code_part = str_replace("http://vimeo.com/","",$code_part);
                    $code_array = explode("/",$code_part);
                    
                    $url_code = (strlen($code_array[0] >2)) ? $code_array[0] : $code_array[1];
                    
                    echo '<p><iframe width="100%" height="284" src="https://player.vimeo.com/video/'.$url_code.'" frameborder="0" allowfullscreen></iframe></p>';
                break;
                
                case "dailymotion" :
                    if(strpos($instance['code_embed'],'dailymotion')){
                        $code_part = str_replace("http://www.dailymotion.com/video/","",$instance['code_embed']);
                        $code_array = explode("_",$code_part);
                    }
                    if(strpos($instance['code_embed'],'dai.ly')){
                        $code_part = str_replace("http://dai.ly/","",$instance['code_embed']);
                        $code_part = str_replace("https://dai.ly/","",$code_part);
                        $code_array = array($code_part);
                    }
                    echo '<p><iframe width="100%" height="284" src="http://www.dailymotion.com/embed/video/'.$code_array[0].'" frameborder="0" allowfullscreen></iframe></p>';
                break;
            
                default:
                    echo '<p><iframe width="100%" height="284" src="https://www.youtube.com/embed/'.$instance["code_embed"].'" frameborder="0" allowfullscreen></iframe></p>';
                break;
            
            }
            
            echo $args['before_title'];
                echo apply_filters('widget_title', $instance['title']);
            echo $args['after_title'];

            echo "<div class='text-widget'>";
                echo "<p>".$instance["content"]."</p>";
            echo "</p>";
        echo "</div>";
        echo $args['after_widget'];
    }
    
    // MAJ BDD - Ajoute les vidéos dans la galerie
    function update( $new_instance, $old_instance ) {
        global $wpdb;
        
        $instance = $old_instance;
        foreach($new_instance as $key => $new){
            $instance[$key] = $new;
        }$instance['title'] = strip_tags($new_instance['title']);
        
        //preg_match('@src="(.*?)"@', $instance['code_embed'], $retour);
        //if(is_array($retour)){ // update videotheque
            
            // Extract code - youtube
            $instance['code_embed'] = str_replace('https://www.youtube.com/embed/','',$instance['code_embed']);
            $instance['code_embed'] = str_replace('https://www.youtube.com/watch?v=','',$instance['code_embed']);
            $instance['code_embed'] = str_replace('https://youtu.be/','',$instance['code_embed']);
            
            $url_youtube = "https://www.youtube.com/embed/".$instance['code_embed'];
            
            // Support dailymotion
            if(strpos($instance['code_embed'],'dailymotion') || strpos($instance['code_embed'],'dai.ly')){
                $url_youtube = $instance['code_embed'];
            }
            
            // Support viméo
            if(strpos($instance['code_embed'],'vimeo.com')){
                $url_youtube = $instance['code_embed'];
            }
            
            
            // Test vidéo allready DB
            //$url_youtube = $retour[1];
            $video = $wpdb->get_results("select * from ".$wpdb->prefix."huge_it_videogallery_videos where sl_url = '".$url_youtube."' or image_url='".$url_youtube."' ");
            if(is_array($video)){
                $wpdb->delete( $wpdb->prefix."huge_it_videogallery_videos", array( 'sl_url' => $url_youtube, 'videogallery_id' => 1 ));
                $wpdb->delete( $wpdb->prefix."huge_it_videogallery_videos", array( 'image_url' => $url_youtube, 'videogallery_id' => 1 ));
            }
            
            if(trim($instance['title']) !=""){
                // Ajoute la vidéo
                $wpdb->insert( $wpdb->prefix.'huge_it_videogallery_videos', array(
                    'name' => $instance['title'],
                    'videogallery_id' => 1,
                    'description'   => "",
                    'image_url'     => $url_youtube,
                    'sl_url'        => $url_youtube,
                    'sl_type'       => "video",
                    'link_target'   => "on",
                    'ordering'      => 1,
                    'published'     => 1,
                    'published_in_sl_width' => 1,
                    'thumb_url' => ""
                ));
            }
            
        //}
        return $instance;
    }
    
    // Form
    public function form($instance){
        $title = isset($instance['title']) ? $instance['title'] : '';
        $code_embed = isset($instance['code_embed']) ? $instance['code_embed'] : '';
        $content = isset($instance['content']) ? $instance['content'] : '';
    ?>
        <p>
            <label for="<?php echo $this->get_field_name( 'title' ); ?>">Titre : </label>
            <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo  htmlspecialchars($title); ?>" />
        </p>
                
        <p>
            <label for="<?php echo $this->get_field_name( 'code_embed' ); ?>">Code embed :</label>
            <textarea class="widefat" id="<?php echo $this->get_field_id( 'code_embed' ); ?>" name="<?php echo $this->get_field_name( 'code_embed' ); ?>"><?php echo  $code_embed; ?></textarea>
        </p>
        
        <p>
            <label for="<?php echo $this->get_field_name( 'content' ); ?>">Contenu :</label>
            <textarea class="htmleditor_widgeted" id="<?php echo $this->get_field_id( 'content' ); ?>" name="<?php echo $this->get_field_name( 'content' ); ?>"><?php echo  $content; ?></textarea>
        </p>
        
        <hr>
            <?php $ancre = ($instance["ancre"]) ? $instance["ancre"] : dh_get_code(8); ?>
            <p>
                <label for="<?php echo $this->get_field_name( 'ancre' ); ?>"><?php _e( 'Ancre :' ); ?></label> Ajouter ico=video ou ico=image ico=pdf avant "]" pour changer l'icone du lien rapide<br>
                <input class="widefat" id="<?php echo $this->get_field_id( 'ancre' ); ?>" name="<?php echo $this->get_field_name( 'ancre' ); ?>" type="text" value="<?php echo  htmlspecialchars($ancre); ?>" />
                Copiez le code ci-dessus pour l'intégrer dans le contenu de l'article.
            </p>
            <br><br>
        
        <?php
    }
}

register_widget('Dh_Widget_Perso_Embed');
add_action('widgets_init', function(){register_widget('Dh_Widget_Perso_Embed');});