<?php get_header(); ?>

<?php
// Get option
$all_articles = get_field("articles_a_attacher");
$colors_category = get_option("category_colors");
$active_color = $colors_category[the_category_ID(false)];
$rbg_active_color = dh_hex2rgb($active_color);
$normal = "rgb(" . $rbg_active_color[0] . ", " . $rbg_active_color[1] . ", " . $rbg_active_color[2] . ");";
$dark = "rgba(" . $rbg_active_color[0] . ", " . $rbg_active_color[1] . ", " . $rbg_active_color[2] . ", 0.6);";
$category = get_the_category($post);
$libelle_post = (!empty(get_field("sous-titre"))) ? get_field("sous-titre") : $category[0]->name;

?>
<style>
    div.post-topic-child:nth-child(2n + 1){
        border-color: <?php echo $normal; ?> !important;
    }
    div.post-topic-child:nth-child(2n + 1) h5,
    div.post-topic-child:nth-child(2n + 1) h4 {
        color: <?php echo $normal; ?> !important;
    }

    div.post-topic-child:nth-child(2n){
        border-color: <?php echo $dark; ?> !important;
    }
    div.post-topic-child:nth-child(2n) h5,
    div.post-topic-child:nth-child(2n) h4 {
        color: <?php echo $dark; ?> !important;
    }

    h3{
        color: <?php echo $normal;?> !important;
        font-size:20px;
    }
    h2{
        font-size:30px !important;
    }

    div.bg-repeat{
        background: url("<?php echo get_template_directory_uri();?>/img/bg_whitetrame.png") center fixed;
        width:100%;
        height:100%;
        position:fixed;
        display:block;
        left:0;
        top:0;
        z-index: -1;
    }
    .post-topic-content{
        column-count:1 !important;
        -moz-column-count:1 !important;
        -webkit-column-count:1 !important;
    }
    
    main.container-topic{
        margin-top: 80px;
    }
    
    main.container-topic section.wrapper-topic div.post-topic-title div.cover-excerpt{
        width:inherit;
    }
</style>

<script>
function pause() {
    if (!element) return;
    // element.pause();
    element.autoplay = false;
}
    
</script>
<main role="main" class="container-topic">
    <section class="wrapper-topic">
        <h1 class="title-cat" style="background-color:<?php echo $active_color; ?>">
            <?php echo $libelle_post; ?>
        </h1>
        <div class="post-topic-title">
            <div class="cover-excerpt">
                <h2><?php echo the_title(); ?></h2>
            </div>
            <div style="clear:both;margin-top:20px;"></div>
            <?php echo '<div style="text-align:left;">'.get_field("chapo_de_larticle").'</div>'; ?>
        </div>

        <div class="post-topic-content">
            <?php if ($all_articles){ ?>
                <div class="post-topic-content">
                    <?php foreach ($all_articles as $article){ ?>
                        <?php $link = get_field("lien_sortant", $article->ID); ?>
                        
                        <div class="post-topic-child">
                            <div class="post-topic-child-img">
                            <?php $post_thumbnail_url = wp_get_attachment_url( $article ); ?>
                                <a href="<?php  echo $post_thumbnail_url; ?>" class="fancybox-button" rel="single-thumb"><?php echo get_the_post_thumbnail($article, 'full'); ?></a>
                            </div>

                            <h5 class="post-topic-child-subtitle">
                                <?php echo get_field("sous-titre", $article->ID); ?>
                            </h5>
                            <h4 class="post-topic-child-title">
                                <?php echo $article->post_title; ?>
                            </h4>

                            <div class="post-topic-child-content">
                                <?php
                                    echo get_field("chapo_de_larticle", $article->ID);
                                    echo "<p class='1'>".apply_filters('the_content',$article->post_content)."</p>";
                                ?>
                            </div>
                            
                            <?php if (!empty($link)){ ?>
                                <div class="post-topic-child-link-out">
                                    <a href="<?php echo $link; ?>" target="_blank">
                                        <span class="icone-en-savoir-plus"></span>
                                        En savoir plus
                                    </a>
                                </div>
                            <?php } ?>
                        </div>
                    <?php } ?>
                </div>
            <?php } ?>
        </div>

        <div style="clear:both"></div>
        <br><br>
    </section>
</main>
<div style="clear:both"></div>
<?php get_footer(); ?>